#include "scripts.h"
#include "engine.h"
#include "jfw5.h"
void JFW_PCT::Poked(GameObject * obj,GameObject * poker)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,team) != 0)
	{
		return;
	}
	if (team == 0)
	{
		Display_NOD_Player_Terminal_Player(poker);
	}
	if (team == 1)
	{
		Display_GDI_Player_Terminal_Player(poker);
	}
	if (team == 2)
	{
		if (Commands->Get_Player_Type(poker) == 0)
		{
			Display_NOD_Player_Terminal_Player(poker);
		}
		if (Commands->Get_Player_Type(poker) == 1)
		{
			Display_GDI_Player_Terminal_Player(poker);
		}
	}
}
void JFW_Preset_Buy_Poke::Poked(GameObject * obj,GameObject * poker)
{
	const char *preset;
	int x;
	int cost;
	Vector3 spawn_position;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(poker))
	{
		cost = -cost;
		spawn_position = Get_Vector3_Parameter("location");
		Commands->Give_Money(poker,(float)cost,0);
		Commands->Create_Object(preset, spawn_position);
	}
}
void JFW_Weapon_Buy_Poke::Poked(GameObject * obj,GameObject * poker)
{
	const char *preset;
	int x;
	int cost;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Weapon_Name");
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(poker))
	{
		cost = -cost;
		Commands->Give_Money(poker,(float)cost,0);
		Commands->Give_Powerup(poker, preset, true);
	}
}
void JFW_Character_Buy_Poke::Poked(GameObject * obj,GameObject * poker)
{
	const char *preset;
	int x;
	int cost;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(poker))
	{
		cost = -cost;
		Commands->Give_Money(poker,(float)cost,0);
		Change_Character(poker,preset);
	}
}
void JFW_Refill_Buy_Poke::Poked(GameObject * obj,GameObject * poker)
{
	int x;
	int cost;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,x) != 0)
	{
		return;
	}
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(poker))
	{
		cost = -cost;
		Commands->Give_Money(poker,(float)cost,0);
		Grant_Refill(poker);
	}
}
void JFW_Powerup_Buy_Poke::Poked(GameObject * obj,GameObject * poker)
{
	const char *preset;
	int x;
	int cost;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(poker))
	{
		cost = -cost;
		Commands->Give_Money(poker,(float)cost,0);
		Grant_Powerup(poker,preset);
	}
}
void JFW_Vehicle_Buy_Poke::Poked(GameObject * obj,GameObject * poker)
{
	const char *preset;
	int x;
	int cost;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	cost = Get_Int_Parameter("Cost");
	if (cost <= Commands->Get_Money(poker))
	{
		cost = -cost;
		Commands->Give_Money(poker,(float)cost,0);
		Create_Vehicle(preset,5.0,poker,x);
	}
}
void JFW_Group_Purchase_Poke::Created(GameObject * obj)
{
	cash = 0;
	enabled = true;
}
void JFW_Group_Purchase_Poke::Poked(GameObject * obj,GameObject * poker)
{
	if (enabled == true)
	{
		float money = Commands->Get_Money(poker);
		if (money >= Get_Float_Parameter("CashPerPerson"))
		{
			Commands->Give_Money(poker,Get_Float_Parameter("CashPerPerson"),0);
			cash += Get_Float_Parameter("CashPerPerson");
		}
		if (cash >= Get_Float_Parameter("TotalCash"))
		{
			cash = 0;
			enabled = false;
			Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),0,0);
		}
	}
}
void JFW_Group_Purchase_Poke::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&cash);
	Auto_Save_Variable(2,1,&enabled);
}
void JFW_Gate_Poke::Poked(GameObject * obj,GameObject * poker)
{
	int Player_Type = Get_Int_Parameter("Player_Type");
	int ID = Get_Int_Parameter("ID");
	const char *Animation = Get_Parameter("Animation");
	int TimerNum = Get_Int_Parameter("TimerNum");
	float Time = Get_Float_Parameter("Time");
	FILE *f = fopen("gp.txt","at");
	fprintf(f,"Player_Type %d ID %d Animation %s TimerNum %d Time %f\n",Player_Type,ID,Animation,TimerNum,Time);
	fflush(f);
	if (CheckPlayerType(poker,Player_Type) != 0)
	{
		return;
	}
	fprintf(f,"2\n");
	fflush(f);
	Commands->Set_Animation(Commands->Find_Object(ID),Animation,false,0,0,-1,false);
	Commands->Start_Timer(obj,this,Time,TimerNum);
	fprintf(f,"x %d\n",Commands->Find_Object(ID));
	fflush(f);
	fprintf(f,"3 %s\n",Commands->Get_Preset_Name(Commands->Find_Object(ID)));
	fflush(f);
	fclose(f);
}
void JFW_Gate_Poke::Timer_Expired(GameObject * obj,int number)
{
	int ID = Get_Int_Parameter("ID");
	const char *Animation = Get_Parameter("Animation");
	int TimerNum = Get_Int_Parameter("TimerNum");
	FILE *f = fopen("gp.txt","at");
	fprintf(f,"x %d",Commands->Find_Object(ID));
	fflush(f);
	fprintf(f,"ID %d Animation %s TimerNum %d\n",ID,Animation,TimerNum);
	fflush(f);
	if (TimerNum == number)
	{
		fprintf(f,"2 %s\n",Commands->Get_Preset_Name(Commands->Find_Object(ID)));
		fflush(f);
		fprintf(f,"o %d\n",Commands->Find_Object(ID));
		fflush(f);
		fprintf(f,"f %f\n",Get_Animation_Frame(Commands->Find_Object(ID)));
		fflush(f);
		fprintf(f,"x %x\n",Get_Animation_Frame(Commands->Find_Object(ID)));
		fflush(f);
		Commands->Set_Animation(Commands->Find_Object(ID),Animation,false,0,Get_Animation_Frame(Commands->Find_Object(ID)),0,false);
		fprintf(f,"3\n");
		fflush(f);
	}
	fclose(f);
}
void JFW_Set_Background_Music_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Set_Background_Music(Get_Parameter("Music"));
	}
}
void JFW_Fade_Background_Music_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Fade_Background_Music(Get_Parameter("Music"),Get_Int_Parameter("unk1"),Get_Int_Parameter("unk2"));
	}
}
void JFW_Stop_Background_Music_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Stop_Background_Music();
	}
}
void JFW_Set_Background_Music_On_Enter::Entered(GameObject * obj,GameObject * enter)
{
	Set_Background_Music_Player(enter,Get_Parameter("Music"));
}
void JFW_Fade_Background_Music_On_Enter::Entered(GameObject * obj,GameObject * enter)
{
	Fade_Background_Music_Player(enter,Get_Parameter("Music"),Get_Int_Parameter("unk1"),Get_Int_Parameter("unk2"));
}
void JFW_Stop_Background_Music_On_Enter::Entered(GameObject * obj,GameObject * enter)
{
	Stop_Background_Music_Player(enter);
}
void JFW_Fog_Create::Created(GameObject *obj)
{
	if (Get_Int_Parameter("OnCreate") > 0)
	{
		if (Get_Float_Parameter("Delay") > 0)
		{
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		}
		else
		{
			bool fogenable = Get_Int_Parameter("Fog_Enable");
			Commands->Set_Fog_Enable(fogenable);
			if (fogenable == true)
			{
				Commands->Set_Fog_Range(Get_Float_Parameter("Fog_Start_Distance"),Get_Float_Parameter("Fog_End_Distance"),1.0f);
			}
		}
	}
}
void JFW_Fog_Create::Destroyed(GameObject *obj)
{
	if (Get_Int_Parameter("OnDestroy") > 0)
	{
		if (Get_Float_Parameter("Delay") > 0)
		{
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		}
		else
		{
			bool fogenable = Get_Int_Parameter("Fog_Enable");
			Commands->Set_Fog_Enable(fogenable);
			if (fogenable == true)
			{
				Commands->Set_Fog_Range(Get_Float_Parameter("Fog_Start_Distance"),Get_Float_Parameter("Fog_End_Distance"),1.0f);
			}
		}
	}
}
void JFW_Fog_Create::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		bool fogenable = Get_Int_Parameter("Fog_Enable");
		Commands->Set_Fog_Enable(fogenable);
		if (fogenable == true)
		{
			Commands->Set_Fog_Range(Get_Float_Parameter("Fog_Start_Distance"),Get_Float_Parameter("Fog_End_Distance"),1.0f);
		}
	}
}
void JFW_Fog_Zone::Entered(GameObject *obj, GameObject *enter)
{
	if (Get_Int_Parameter("OnEnter") > 0)
	{
		if (Get_Float_Parameter("Delay") > 0)
		{
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		}
		else
		{
			bool fogenable = Get_Int_Parameter("Fog_Enable");
			Commands->Set_Fog_Enable(fogenable);
			if (fogenable == true)
			{
				Commands->Set_Fog_Range(Get_Float_Parameter("Fog_Start_Distance"),Get_Float_Parameter("Fog_End_Distance"),1.0f);
			}
		}
	}
}
void JFW_Fog_Zone::Exited(GameObject *obj, GameObject *exit)
{
	if (Get_Int_Parameter("OnExit") > 0)
	{
		if (Get_Float_Parameter("Delay") > 0)
		{
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		}
		else
		{
			bool fogenable = Get_Int_Parameter("Fog_Enable");
			Commands->Set_Fog_Enable(fogenable);
			if (fogenable == true)
			{
				Commands->Set_Fog_Range(Get_Float_Parameter("Fog_Start_Distance"),Get_Float_Parameter("Fog_End_Distance"),1.0f);
			}
		}
	}
}
void JFW_Fog_Zone::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		bool fogenable = Get_Int_Parameter("Fog_Enable");
		Commands->Set_Fog_Enable(fogenable);
		if (fogenable == true)
		{
			Commands->Set_Fog_Range(Get_Float_Parameter("Fog_Start_Distance"),Get_Float_Parameter("Fog_End_Distance"),1.0f);
		}
	}
}
void JFW_War_Blitz_Create::Created(GameObject *obj)
{
	if (Get_Int_Parameter("OnCreate") > 0)
	{
		if (Get_Float_Parameter("Delay") > 0)
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		else
			Commands->Set_War_Blitz(Get_Float_Parameter("War_Blitz_Intensity"),Get_Float_Parameter("Start_Distance"),Get_Float_Parameter("End_Distance"),Get_Float_Parameter("War_Blitz_Heading"),Get_Float_Parameter("War_Blitz_Distribution"),1.0f);
	}
}
void JFW_War_Blitz_Create::Destroyed(GameObject *obj)
{
	if (Get_Int_Parameter("OnDestroy") > 0)
	{
		if (Get_Float_Parameter("Delay") > 0)
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		else 
			Commands->Set_War_Blitz(Get_Float_Parameter("War_Blitz_Intensity"),Get_Float_Parameter("Start_Distance"),Get_Float_Parameter("End_Distance"),Get_Float_Parameter("War_Blitz_Heading"),Get_Float_Parameter("War_Blitz_Distribution"),1.0f);
	}
}
void JFW_War_Blitz_Create::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
		Commands->Set_War_Blitz(Get_Float_Parameter("War_Blitz_Intensity"),Get_Float_Parameter("Start_Distance"),Get_Float_Parameter("End_Distance"),Get_Float_Parameter("War_Blitz_Heading"),Get_Float_Parameter("War_Blitz_Distribution"),1.0f);
}
void JFW_War_Blitz_Zone::Entered(GameObject *obj, GameObject *enter)
{
	if (Get_Int_Parameter("OnEnter") > 0)
	{
		if (Get_Float_Parameter("Delay") > 0)
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		else
			Commands->Set_War_Blitz(Get_Float_Parameter("War_Blitz_Intensity"),Get_Float_Parameter("Start_Distance"),Get_Float_Parameter("End_Distance"),Get_Float_Parameter("War_Blitz_Heading"),Get_Float_Parameter("War_Blitz_Distribution"),1.0f);
	}
}
void JFW_War_Blitz_Zone::Exited(GameObject *obj, GameObject *exit)
{
	if (Get_Int_Parameter("OnExit") > 0)
	{
		if (Get_Float_Parameter("Delay") > 0)
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		else
			Commands->Set_War_Blitz(Get_Float_Parameter("War_Blitz_Intensity"),Get_Float_Parameter("Start_Distance"),Get_Float_Parameter("End_Distance"),Get_Float_Parameter("War_Blitz_Heading"),Get_Float_Parameter("War_Blitz_Distribution"),1.0f);
	}
}
void JFW_War_Blitz_Zone::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
		Commands->Set_War_Blitz(Get_Float_Parameter("War_Blitz_Intensity"),Get_Float_Parameter("Start_Distance"),Get_Float_Parameter("End_Distance"),Get_Float_Parameter("War_Blitz_Heading"),Get_Float_Parameter("War_Blitz_Distribution"),1.0f);
}
void JFW_Fog_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (Get_Int_Parameter("Message") == message)
	{
		if (Get_Float_Parameter("Delay") > 0)
		{
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		}
		else
		{
			bool fogenable = Get_Int_Parameter("Fog_Enable");
			Commands->Set_Fog_Enable(fogenable);
			if (fogenable == true)
			{
				Commands->Set_Fog_Range(Get_Float_Parameter("Fog_Start_Distance"),Get_Float_Parameter("Fog_End_Distance"),1.0f);
			}
		}
	}
}
void JFW_Fog_Custom::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		bool fogenable = Get_Int_Parameter("Fog_Enable");
		Commands->Set_Fog_Enable(fogenable);
		if (fogenable == true)
		{
			Commands->Set_Fog_Range(Get_Float_Parameter("Fog_Start_Distance"),Get_Float_Parameter("Fog_End_Distance"),1.0f);
		}
	}
}
void JFW_War_Blitz_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (Get_Int_Parameter("Message") == message)
	{
		if (Get_Float_Parameter("Delay") > 0)
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		else
			Commands->Set_War_Blitz(Get_Float_Parameter("War_Blitz_Intensity"),Get_Float_Parameter("Start_Distance"),Get_Float_Parameter("End_Distance"),Get_Float_Parameter("War_Blitz_Heading"),Get_Float_Parameter("War_Blitz_Distribution"),1.0f);
	}
}
void JFW_War_Blitz_Custom::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
		Commands->Set_War_Blitz(Get_Float_Parameter("War_Blitz_Intensity"),Get_Float_Parameter("Start_Distance"),Get_Float_Parameter("End_Distance"),Get_Float_Parameter("War_Blitz_Heading"),Get_Float_Parameter("War_Blitz_Distribution"),1.0f);
}
void JFW_Wind_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (Get_Int_Parameter("Message") == message)
	{
		if (Get_Float_Parameter("Delay") > 0)
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		else
			Commands->Set_Wind(Get_Float_Parameter("Wind_Heading"),Get_Float_Parameter("Wind_Speed"),Get_Float_Parameter("Wind_Variability"),1.0f);
	}
}
void JFW_Wind_Custom::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
		Commands->Set_Wind(Get_Float_Parameter("Wind_Heading"),Get_Float_Parameter("Wind_Speed"),Get_Float_Parameter("Wind_Variability"),1.0f);
}
void JFW_Lightning_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (Get_Int_Parameter("Message") == message)
	{
		if (Get_Float_Parameter("Delay") > 0)
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		else
			Commands->Set_Lightning(Get_Float_Parameter("Lightning_Intensity"),Get_Float_Parameter("Start_Distance"),Get_Float_Parameter("End_Distance"),Get_Float_Parameter("Lightning_Heading"),Get_Float_Parameter("Lightning_Distribution"),1.0f);
	}
}
void JFW_Lightning_Custom::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
		Commands->Set_Lightning(Get_Float_Parameter("Lightning_Intensity"),Get_Float_Parameter("Start_Distance"),Get_Float_Parameter("End_Distance"),Get_Float_Parameter("Lightning_Heading"),Get_Float_Parameter("Lightning_Distribution"),1.0f);
}
void JFW_Building_Damage_Percentage::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Ranged_Percentage_Damage_To_Buildings_Team(Get_Int_Parameter("Player_Type"),Get_Float_Parameter("Percentage"),Get_Parameter("Warhead"),Commands->Get_Position(sender),Get_Float_Parameter("Distance"),Commands->Find_Object(param));
	}
}
void JFW_Clouds_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (Get_Int_Parameter("Message") == message)
	{
		if (Get_Float_Parameter("Delay") > 0)
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		else
			Commands->Set_Clouds(Get_Float_Parameter("Cloud_Cover"),Get_Float_Parameter("Cloud_Gloominess"),1.0f);
	}
}
void JFW_Clouds_Custom::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
		Commands->Set_Clouds(Get_Float_Parameter("Cloud_Cover"),Get_Float_Parameter("Cloud_Gloominess"),1.0f);
}
void JFW_Precipitation_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (Get_Int_Parameter("Message") == message)
	{
		if (Get_Float_Parameter("Delay") > 0)
			Commands->Start_Timer(obj,this,Get_Float_Parameter("Delay"),1);
		else
		{
			if (Get_Int_Parameter("Reset_Precipitation") > 0)
			{
				Commands->Set_Snow(0.0f,0.0f,true);
				Commands->Set_Ash(0.0f,0.0f,true);
				Commands->Set_Rain(0.0f,0.0f,true);
			}
			if (strcmp(Get_Parameter("Type"),"Snow") == 0) Commands->Set_Snow(Get_Float_Parameter("Density"),Get_Float_Parameter("Density"),true);
			else if (strcmp(Get_Parameter("Type"),"Ash") == 0) Commands->Set_Ash(Get_Float_Parameter("Density"),Get_Float_Parameter("Density"),true);
			else if (strcmp(Get_Parameter("Type"),"Rain") == 0) Commands->Set_Rain(Get_Float_Parameter("Density"),Get_Float_Parameter("Density"),true);
			else
			{
				Commands->Set_Snow(0.0f,0.0f,true);
				Commands->Set_Ash(0.0f,0.0f,true);
				Commands->Set_Rain(0.0f,0.0f,true);
			}
		}
	}
}
void JFW_Precipitation_Custom::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		if (Get_Int_Parameter("Reset_Precipitation") > 0)
		{
			Commands->Set_Snow(0.0f,0.0f,true);
			Commands->Set_Ash(0.0f,0.0f,true);
			Commands->Set_Rain(0.0f,0.0f,true);
		}
		if (strcmp(Get_Parameter("Type"),"Snow") == 0) Commands->Set_Snow(Get_Float_Parameter("Density"),Get_Float_Parameter("Density"),true);
		else if (strcmp(Get_Parameter("Type"),"Ash") == 0) Commands->Set_Ash(Get_Float_Parameter("Density"),Get_Float_Parameter("Density"),true);
		else if (strcmp(Get_Parameter("Type"),"Rain") == 0) Commands->Set_Rain(Get_Float_Parameter("Density"),Get_Float_Parameter("Density"),true);
		else
		{
			Commands->Set_Snow(0.0f,0.0f,true);
			Commands->Set_Ash(0.0f,0.0f,true);
			Commands->Set_Rain(0.0f,0.0f,true);
		}
	}
}
void JFW_Screen_Fade_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Set_Screen_Fade_Opacity_Player(obj,Get_Float_Parameter("Opacity"),0.0f);
		Set_Screen_Fade_Color_Player(obj,Get_Float_Parameter("Red"),Get_Float_Parameter("Green"),Get_Float_Parameter("Blue"),0.0f);
	}
}
void JFW_Enable_Stealth_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Enable_Stealth(obj,Get_Int_Parameter("Enable"));
	}
}
void JFW_Goto_Object_On_Startup::Created(GameObject * obj)
{
	ActionParamsStruct params;
	params.Set_Basic(this,100,2,-1);
	params.Set_Goto(Commands->Find_Object(Get_Int_Parameter("ID")),Get_Float_Parameter("Speed"),Get_Float_Parameter("Arrivedistance"));
	Commands->Action_Goto(obj,params);
}
void JFW_Enable_Team_Radar_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Enable_Team_Radar(Get_Int_Parameter("Player_Type"),Get_Int_Parameter("Enable"));
	}
}
void JFW_Disable_Radar_Zone::Entered(GameObject * obj,GameObject * enter)
{
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(enter,x) != 0)
	{
		return;
	}
	Enable_Radar_Player(enter,false);
}
void JFW_Disable_Radar_Zone::Exited(GameObject * obj,GameObject * exit)
{
	int x;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(exit,x) != 0)
	{
		return;
	}
	Enable_Radar_Player(exit,true);
}
void JFW_Poke_Send_Custom_2::Poked(GameObject * obj,GameObject * poker)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,team) != 0)
	{
		return;
	}
	Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),Get_Int_Parameter("Param"),0);
}
void JFW_Poke_Send_Custom_Preset::Poked(GameObject * obj,GameObject * poker)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,team) != 0)
	{
		return;
	}
	if (stricmp(Commands->Get_Preset_Name(poker),Get_Parameter("Preset")) != 0)
	{
		return;
	}
	Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),Get_Int_Parameter("Param"),0);
}
void JFW_Poke_Send_Custom_Keycard::Poked(GameObject * obj,GameObject * poker)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,team) != 0)
	{
		return;
	}
	if (Commands->Has_Key(poker,Get_Int_Parameter("Key")) == 0)
	{
		return;
	}
	Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),Get_Int_Parameter("Param"),0);
}
void JFW_Poke_Send_Custom_Cost::Poked(GameObject * obj,GameObject * poker)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,team) != 0)
	{
		return;
	}
	if (Commands->Get_Money(poker) < Get_Float_Parameter("Cost"))
	{
		return;
	}
	Commands->Give_Money(poker,-Get_Float_Parameter("Cost"),false);
	Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("ID")),Get_Int_Parameter("Message"),Get_Int_Parameter("Param"),0);
}
void JFW_Poke_Play_2D_Sound::Poked(GameObject * obj,GameObject * poker)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,team) != 0)
	{
		return;
	}
	Commands->Create_2D_Sound(Get_Parameter("Sound"));
}
void JFW_Poke_Play_3D_Sound::Poked(GameObject * obj,GameObject * poker)
{
	int team;
	team = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,team) != 0)
	{
		return;
	}
	Commands->Create_Sound(Get_Parameter("Sound"),Get_Vector3_Parameter("Position"),obj);
}
void JFW_Screen_Fade_On_Enter::Entered(GameObject * obj,GameObject * enter)
{
	Set_Screen_Fade_Opacity_Player(enter,Get_Float_Parameter("Opacity"),0.0f);
	Set_Screen_Fade_Color_Player(enter,Get_Float_Parameter("Red"),Get_Float_Parameter("Green"),Get_Float_Parameter("Blue"),0.0f);
}
void JFW_Screen_Fade_On_Exit::Exited(GameObject * obj,GameObject * exit)
{
	Set_Screen_Fade_Opacity_Player(exit,Get_Float_Parameter("Opacity"),0.0f);
	Set_Screen_Fade_Color_Player(exit,Get_Float_Parameter("Red"),Get_Float_Parameter("Green"),Get_Float_Parameter("Blue"),0.0f);
}
void JFW_BHS_DLL::Created(GameObject * obj)
{
	Console_Output("BHS.DLL is required for this map");
}
void JFW_Console_Message_On_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Console_Output(Get_Parameter("Output"));
	}
}
ScriptRegistrant<JFW_Character_Buy_Poke> JFW_Character_Buy_Poke_Registrant("JFW_Character_Buy_Poke","Preset_Name:string,Cost:int,Player_Type:int");
ScriptRegistrant<JFW_Refill_Buy_Poke> JFW_Refill_Buy_Poke_Registrant("JFW_Refill_Buy_Poke","Cost:int,Player_Type:int");
ScriptRegistrant<JFW_Vehicle_Buy_Poke> JFW_Vehicle_Buy_Poke_Registrant("JFW_Vehicle_Buy_Poke","Preset_Name:string,Cost:int,Player_Type:int");
ScriptRegistrant<JFW_Powerup_Buy_Poke> JFW_Powerup_Buy_Poke_Registrant("JFW_Powerup_Buy_Poke","Preset_Name:string,Cost:int,Player_Type:int");
ScriptRegistrant<JFW_Weapon_Buy_Poke> JFW_Weapon_Buy_Poke_Registrant("JFW_Weapon_Buy_Poke","Weapon_Name:string,Cost:int,Player_Type:int");
ScriptRegistrant<JFW_Preset_Buy_Poke> JFW_Preset_Buy_Poke_Registrant("JFW_Preset_Buy_Poke","Preset_Name:string,Cost:int,location:Vector3,Player_Type:int");
ScriptRegistrant<JFW_PCT> JFW_PCT_Registrant("JFW_PCT","Player_Type:int");
ScriptRegistrant<JFW_Group_Purchase_Poke> JFW_Group_Purchase_Poke_Registrant("JFW_Group_Purchase_Poke","CashPerPerson:float,TotalCash:float,ID:int,Custom:int");
ScriptRegistrant<JFW_Gate_Poke> JFW_Gate_Poke_Registrant("JFW_Gate_Poke","Player_Type:int,Time:Float,TimerNum:int,ID:int,Animation:string");
ScriptRegistrant<JFW_Set_Background_Music_On_Custom> JFW_Set_Background_Music_On_Custom_Registrant("JFW_Set_Background_Music_On_Custom","Message:int,Music:string");
ScriptRegistrant<JFW_Fade_Background_Music_On_Custom> JFW_Fade_Background_Music_On_Custom_Registrant("JFW_Fade_Background_Music_On_Custom","Message:int,Music:string,unk1:int,unk2:int");
ScriptRegistrant<JFW_Stop_Background_Music_On_Custom> JFW_Stop_Background_Music_On_Custom_Registrant("JFW_Stop_Background_Music_On_Custom","Message:int");
ScriptRegistrant<JFW_Set_Background_Music_On_Enter> JFW_Set_Background_Music_On_Enter_Registrant("JFW_Set_Background_Music_On_Enter","Music:string");
ScriptRegistrant<JFW_Fade_Background_Music_On_Enter> JFW_Fade_Background_Music_On_Enter_Registrant("JFW_Fade_Background_Music_On_Enter","Music:string,unk1:int,unk2:int");
ScriptRegistrant<JFW_Stop_Background_Music_On_Enter> JFW_Stop_Background_Music_On_Enter_Registrant("JFW_Stop_Background_Music_On_Enter","");
ScriptRegistrant<JFW_Fog_Create> JFW_Fog_Create_Registrant("JFW_Fog_Create","Fog_Enable:int,Fog_Start_Distance=0.000:float,Fog_End_Distance=0.000:float,Delay=0.000:float,OnCreate=0:int,OnDestroy=0:int");
ScriptRegistrant<JFW_Fog_Custom> JFW_Fog_Custom_Registrant("JFW_Fog_Custom","Fog_Enable:int,Fog_Start_Distance=0.000:float,Fog_End_Distance=0.000:float,Delay=0.000:float,Message:int");
ScriptRegistrant<JFW_Fog_Zone> JFW_Fog_Zone_Registrant("JFW_Fog_Zone","Fog_Enable:int,Fog_Start_Distance=0.000:float,Fog_End_Distance=0.000:float,Delay=0.000:float,OnEnter=0:int,OnExit=0:int");
ScriptRegistrant<JFW_War_Blitz_Create> JFW_War_Blitz_Create_Registrant("JFW_War_Blitz_Create","War_Blitz_Intensity=0.000:float,Start_Distance=0.000:float,End_Distance=1.000:float,War_Blitz_Heading=0.000:float,War_Blitz_Distribution=1.000:float,Delay=0.000:float,OnCreate=0:int,OnDestroy=0:int");
ScriptRegistrant<JFW_War_Blitz_Custom> JFW_War_Blitz_Custom_Registrant("JFW_War_Blitz_Custom","War_Blitz_Intensity=0.000:float,Start_Distance=0.000:float,End_Distance=1.000:float,War_Blitz_Heading=0.000:float,War_Blitz_Distribution=1.000:float,Delay=0.000:float,Message:int");
ScriptRegistrant<JFW_War_Blitz_Zone> JFW_War_Blitz_Zone_Registrant("JFW_War_Blitz_Zone","War_Blitz_Intensity=0.000:float,Start_Distance=0.000:float,End_Distance=1.000:float,War_Blitz_Heading=0.000:float,War_Blitz_Distribution=1.000:float,Delay=0.000:float,OnEnter=0:int,OnExit=0:int");
ScriptRegistrant<JFW_Lightning_Custom> JFW_Lightning_Custom_Registrant("JFW_Lightning_Custom","Lightning_Intensity=0.000:float,Start_Distance=0.000:float,End_Distance=1.000:float,Lightning_Heading=0.000:float,Lightning_Distribution=1.000:float,Delay=0.000:float,Message:int");
ScriptRegistrant<JFW_Wind_Custom> JFW_Wind_Custom_Registrant("JFW_Wind_Custom","Wind_Heading=0.000:float,Wind_Speed=0.000:float,Wind_Variability=0.000:float,Delay=0.000:float,Message:int");
ScriptRegistrant<JFW_Building_Damage_Percentage> JFW_Building_Damage_Percentage_Registrant("JFW_Building_Damage_Percentage","Message:int,Player_Type:int,Percentage:float,Warhead:string,Distance:float");
ScriptRegistrant<JFW_Precipitation_Custom> JFW_Precipitation_Custom_Registrant("JFW_Precipitation_Custom","Type=Rain:string,Density=0.000:float,Delay=0.000:float,Reset_Precipitation=0:int,Message:int");
ScriptRegistrant<JFW_Clouds_Custom> JFW_Clouds_Custom_Registrant("JFW_Clouds_Custom","Cloud_Cover=0.000:float,Cloud_Gloominess=0.000:float,Delay=0.000:float,Message:int");
ScriptRegistrant<JFW_Screen_Fade_On_Custom> JFW_Screen_Fade_On_Custom_Registrant("JFW_Screen_Fade_On_Custom","Message:int,Red:float,Green:float,Blue:float,Opacity:float");
ScriptRegistrant<JFW_Enable_Stealth_On_Custom> JFW_Enable_Stealth_On_Custom_Registrant("JFW_Enable_Stealth_On_Custom","Message:int,Enable:int");
ScriptRegistrant<JFW_Goto_Object_On_Startup> JFW_Goto_Object_On_Startup_Registrant("JFW_Goto_Object_On_Startup","ID:int,Speed:float,ArriveDistance:float");
ScriptRegistrant<JFW_Enable_Team_Radar_On_Custom> JFW_Enable_Team_Radar_On_Custom_Registrant("JFW_Enable_Team_Radar_On_Custom","Player_Type:int,Message:int,Enable:int");
ScriptRegistrant<JFW_Disable_Radar_Zone> JFW_Disable_Radar_Zone_Registrant("JFW_Disable_Radar_Zone","Player_Type:int");
ScriptRegistrant<JFW_Poke_Send_Custom_2> JFW_Poke_Send_Custom_2_Registrant("JFW_Poke_Send_Custom_2","Player_Type:int,ID:int,Message:int,Param:int");
ScriptRegistrant<JFW_Poke_Send_Custom_Preset> JFW_Poke_Send_Custom_Preset_Registrant("JFW_Poke_Send_Custom_Preset","Player_Type:int,ID:int,Message:int,Param:int,Preset:string");
ScriptRegistrant<JFW_Poke_Send_Custom_Keycard> JFW_Poke_Send_Custom_Keycard_Registrant("JFW_Poke_Send_Custom_Keycard","Player_Type:int,ID:int,Message:int,Param:int,Key:int");
ScriptRegistrant<JFW_Poke_Send_Custom_Cost> JFW_Poke_Send_Custom_Cost_Registrant("JFW_Poke_Send_Custom_Cost","Player_Type:int,ID:int,Message:int,Param:int,Cost:float");
ScriptRegistrant<JFW_Poke_Play_2D_Sound> JFW_Poke_Play_2D_Sound_Registrant("JFW_Poke_Play_2D_Sound","Player_Type:int,Sound:string");
ScriptRegistrant<JFW_Poke_Play_3D_Sound> JFW_Poke_Play_3D_Sound_Registrant("JFW_Poke_Play_3D_Sound","Player_Type:int,Sound:string,Position:Vector3");
ScriptRegistrant<JFW_Screen_Fade_On_Enter> JFW_Screen_Fade_On_Enter_Registrant("JFW_Screen_Fade_On_Enter","Red:float,Green:float,Blue:float,Opacity:float");
ScriptRegistrant<JFW_Screen_Fade_On_Exit> JFW_Screen_Fade_On_Exit_Registrant("JFW_Screen_Fade_On_Exit","Red:float,Green:float,Blue:float,Opacity:float");
ScriptRegistrant<JFW_Console_Message_On_Custom> JFW_Console_Message_On_Custom_Registrant("JFW_Console_Message_On_Custom","Message:int,Output:string");
ScriptRegistrant<JFW_BHS_DLL> JFW_BHS_DLL_Registrant("JFW_BHS_DLL","");
